<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\ContratoService;

class ContratoCreditoController extends Controller
{
    public function __construct(private ContratoService $contratoService) {}

    public function index()
    {
        return response()->json($this->contratoService->list());
    }

    public function store(Request $request)
    {
        return response()->json($this->contratoService->create($request->all()), 201);
    }

    public function show(string $id)
    {
        return response()->json($this->contratoService->find($id));
    }

    public function update(Request $request, string $id)
    {
        return response()->json($this->contratoService->update($id, $request->all()));
    }

    public function destroy(string $id)
    {
        $this->contratoService->delete($id);
        return response()->json(['message' => 'Contrato removido']);
    }
}
