<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PessoaJuridica;

class PessoaJuridicaController extends Controller
{
    public function index()
    {
        return response()->json(PessoaJuridica::paginate());
    }

    public function store(Request $request)
    {
        $pessoa = PessoaJuridica::create($request->all());
        return response()->json($pessoa, 201);
    }

    public function show(string $id)
    {
        return response()->json(PessoaJuridica::with(['enderecos','contatos','socios'])->findOrFail($id));
    }

    public function update(Request $request, string $id)
    {
        $pessoa = PessoaJuridica::findOrFail($id);
        $pessoa->update($request->all());
        return response()->json($pessoa);
    }

    public function destroy(string $id)
    {
        PessoaJuridica::findOrFail($id)->delete();
        return response()->json(['message' => 'Registro removido']);
    }
}
