<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PropostaCredito extends Model
{
    use HasFactory;

    protected $fillable = [
        'lead_id',
        'pessoa_fisica_id',
        'pessoa_juridica_id',
        'imovel_id',
        'status',
        'valor_solicitado',
        'prazo',
        'taxa',
        'canal',
        'responsavel_id',
    ];

    public function lead()
    {
        return $this->belongsTo(Lead::class);
    }

    public function imovel()
    {
        return $this->belongsTo(Imovel::class);
    }

    public function pessoaFisica()
    {
        return $this->belongsTo(PessoaFisica::class, 'pessoa_fisica_id');
    }

    public function pessoaJuridica()
    {
        return $this->belongsTo(PessoaJuridica::class, 'pessoa_juridica_id');
    }

    public function documentos()
    {
        return $this->hasMany(PropostaDocumento::class, 'proposta_id');
    }

    public function historicos()
    {
        return $this->hasMany(PropostaHistoricoStatus::class, 'proposta_id');
    }

    public function scores()
    {
        return $this->hasMany(PropostaScoreInterno::class, 'proposta_id');
    }

    public function analisesRisco()
    {
        return $this->hasMany(PropostaAnaliseRisco::class, 'proposta_id');
    }

    public function contrato()
    {
        return $this->hasOne(ContratoCredito::class, 'proposta_id');
    }
}
