<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class DoclingService
{
    public function extractFromPath(string $path): array
    {
        $url = $this->baseUrl();
        if (!$url) {
            return [
                'ok' => false,
                'error' => 'Servico Docling nao configurado.',
            ];
        }

        try {
            $response = Http::timeout(120)->post($url.'/extract-path', [
                'path' => $path,
            ]);
        } catch (\Throwable $exception) {
            return [
                'ok' => false,
                'error' => $exception->getMessage(),
            ];
        }

        if (!$response->successful()) {
            return [
                'ok' => false,
                'error' => 'Falha ao chamar Docling.',
            ];
        }

        $payload = $response->json();
        if (!is_array($payload)) {
            return [
                'ok' => false,
                'error' => 'Resposta invalida do Docling.',
            ];
        }

        if (!($payload['success'] ?? true)) {
            return [
                'ok' => false,
                'error' => $payload['error'] ?? 'Docling retornou erro.',
            ];
        }

        return [
            'ok' => true,
            'text' => $payload['text'] ?? $payload['markdown'] ?? '',
            'markdown' => $payload['markdown'] ?? '',
            'meta' => $payload['meta'] ?? [],
            'raw' => $payload,
        ];
    }

    private function baseUrl(): ?string
    {
        $url = env('COMPLIANCE_DOCLING_URL', 'http://127.0.0.1:8009');
        $url = trim((string) $url);
        return $url === '' ? null : rtrim($url, '/');
    }
}
