<?php

namespace App\Http\Controllers;

use App\Models\AgendaEvento;
use App\Models\AgendaEventoMensagem;
use App\Services\AgendaService;
use Illuminate\Http\Request;

class AgendaMensagemController extends Controller
{
    public function __construct(private AgendaService $service)
    {
    }

    public function index(Request $request, AgendaEvento $agenda)
    {
        $user = $request->user();
        if (!$this->service->canView($user, $agenda)) {
            return response()->json(['message' => 'Sem permissao para visualizar.'], 403);
        }

        $mensagens = AgendaEventoMensagem::query()
            ->where('evento_id', $agenda->id)
            ->with('usuario:id,name')
            ->orderBy('created_at')
            ->get();

        return response()->json($mensagens);
    }

    public function store(Request $request, AgendaEvento $agenda)
    {
        $user = $request->user();
        if (!$this->service->canView($user, $agenda)) {
            return response()->json(['message' => 'Sem permissao para enviar.'], 403);
        }

        $data = $request->validate([
            'mensagem' => ['required', 'string', 'max:2000'],
        ]);

        $mensagem = AgendaEventoMensagem::query()->create([
            'evento_id' => $agenda->id,
            'usuario_id' => $user->id,
            'mensagem' => $data['mensagem'],
        ]);

        return response()->json($mensagem->load('usuario:id,name'), 201);
    }
}
