<?php

namespace App\Http\Controllers;

use App\Models\ContratoCredito;
use Illuminate\Http\Request;

class ContratoCreditoController extends Controller
{
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $this->requireRole(['admin', 'gestor']);
            return $next($request);
        });
    }

    public function index()
    {
        $contratos = ContratoCredito::query()
            ->with(['cliente', 'propostaCredito'])
            ->orderByDesc('id')
            ->paginate(20);

        return response()->json($contratos);
    }

    public function create()
    {
        return response()->json(['message' => 'create']);
    }

    public function store(Request $request)
    {
        $registro = ContratoCredito::query()->create($request->only([
            'cliente_id',
            'proposta_id',
            'valor_liberado',
            'prazo_meses',
            'taxa_juros',
            'indexador_id',
            'status_contrato_id',
            'data_assinatura',
        ]));

        return response()->json($registro->load(['cliente', 'propostaCredito']), 201);
    }

    public function show(int $id)
    {
        $contrato = ContratoCredito::query()
            ->with(['cliente', 'propostaCredito'])
            ->findOrFail($id);

        return response()->json($contrato);
    }

    public function edit(int $id)
    {
        return response()->json(ContratoCredito::query()->findOrFail($id));
    }

    public function update(Request $request, int $id)
    {
        $registro = ContratoCredito::query()->findOrFail($id);
        $registro->update($request->only([
            'proposta_id',
            'valor_liberado',
            'prazo_meses',
            'taxa_juros',
            'indexador_id',
            'status_contrato_id',
            'data_assinatura',
        ]));

        return response()->json($registro->load(['cliente', 'propostaCredito']));
    }

    public function destroy(int $id)
    {
        ContratoCredito::query()->whereKey($id)->delete();
        return response()->noContent();
    }
}
