<?php

namespace App\Http\Controllers;

use App\Models\Imovel;
use Illuminate\Http\Request;

class ImovelController extends Controller
{
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $this->requireRole(['admin', 'gestor']);
            return $next($request);
        });
    }

    public function index()
    {
        $imoveis = Imovel::query()
            ->with('cliente')
            ->orderByDesc('id')
            ->paginate(20);

        return response()->json($imoveis);
    }

    public function create()
    {
        return response()->json(['message' => 'create']);
    }

    public function store(Request $request)
    {
        $registro = Imovel::query()->create($request->only([
            'cliente_id',
            'tipo_imovel_id',
            'cep',
            'logradouro',
            'numero',
            'bairro',
            'cidade',
            'estado',
            'metragem_m2',
            'valor_avaliacao',
            'valor_credito',
            'saldo_devedor',
            'em_condominio',
            'propriedade',
        ]));

        return response()->json($registro->load('cliente'), 201);
    }

    public function show(int $id)
    {
        $imovel = Imovel::query()
            ->with('cliente')
            ->findOrFail($id);

        return response()->json($imovel);
    }

    public function edit(int $id)
    {
        return response()->json(Imovel::query()->findOrFail($id));
    }

    public function update(Request $request, int $id)
    {
        $registro = Imovel::query()->findOrFail($id);
        $registro->update($request->only([
            'tipo_imovel_id',
            'cep',
            'logradouro',
            'numero',
            'bairro',
            'cidade',
            'estado',
            'metragem_m2',
            'valor_avaliacao',
            'valor_credito',
            'saldo_devedor',
            'em_condominio',
            'propriedade',
        ]));

        return response()->json($registro->load('cliente'));
    }

    public function destroy(int $id)
    {
        Imovel::query()->whereKey($id)->delete();
        return response()->noContent();
    }
}
