<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AgendaEventoLembrete extends Model
{
    protected $table = 'agenda_evento_lembretes';

    protected $fillable = [
        'evento_id',
        'destinatario_tipo',
        'destinatario_id',
        'destinatario_telefone',
        'enviar_em',
        'enviado_em',
        'status',
        'tentativas',
        'erro_ultima',
    ];

    protected $casts = [
        'enviar_em' => 'datetime',
        'enviado_em' => 'datetime',
        'tentativas' => 'integer',
    ];

    public function evento()
    {
        return $this->belongsTo(AgendaEvento::class, 'evento_id');
    }

    public function usuario()
    {
        return $this->belongsTo(Usuario::class, 'destinatario_id');
    }
}
