<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CondicaoCredito extends Model
{
    protected $fillable = ['proposta_credito_id', 'taxa_juros_id', 'indexador', 'prazo_meses', 'carencia_meses'];

    public function propostaCredito()
    {
        return $this->belongsTo(PropostaCredito::class);
    }

    public function taxaJuros()
    {
        return $this->belongsTo(TaxaJuros::class);
    }

    public function taxaJuroses()
    {
        return $this->hasMany(TaxaJuros::class);
    }

}

