<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ContaBancaria extends Model
{
    protected $fillable = ['banco_id', 'agencia', 'numero', 'tipo', 'saldo_atual'];

    public function banco()
    {
        return $this->belongsTo(Banco::class);
    }

    public function contasPagar()
    {
        return $this->hasMany(ContaPagar::class);
    }

    public function contasReceber()
    {
        return $this->hasMany(ContaReceber::class);
    }

    public function pagamentos()
    {
        return $this->hasMany(Pagamento::class);
    }

    public function extratoFinanceiros()
    {
        return $this->hasMany(ExtratoFinanceiro::class);
    }

}

