<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ParcelaContrato extends Model
{
    protected $fillable = ['contrato_credito_id', 'numero_parcela', 'valor', 'data_vencimento', 'status'];

    public function contratoCredito()
    {
        return $this->belongsTo(ContratoCredito::class);
    }

    public function pagamentos()
    {
        return $this->hasMany(Pagamento::class);
    }

    public function atrasos()
    {
        return $this->hasMany(Atraso::class);
    }

}

