<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('leads', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('email')->nullable();
            $table->string('telefone', 30)->nullable();
            $table->string('origem', 120)->nullable();
            $table->string('status', 50)->default('novo');
            $table->unsignedBigInteger('responsavel_id')->nullable();
            $table->unsignedBigInteger('pessoa_fisica_id')->nullable();
            $table->unsignedBigInteger('pessoa_juridica_id')->nullable();
            $table->timestamps();

            $table->index(['status', 'origem']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('leads');
    }
};
