<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('imoveis')) {
            return;
        }

        Schema::create('imoveis', function (Blueprint $table) {
            $table->id();
            $table->string('tipo', 50);
            $table->string('matricula', 100)->nullable();
            $table->decimal('area_total', 12, 2)->nullable();
            $table->decimal('valor_estimado', 18, 2)->nullable();
            $table->string('status', 30)->nullable();
            $table->unsignedBigInteger('pessoa_fisica_id')->nullable();
            $table->unsignedBigInteger('pessoa_juridica_id')->nullable();
            $table->timestamps();

            $table->index('pessoa_fisica_id');
            $table->index('pessoa_juridica_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('imoveis');
    }
};
