<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('propostas_credito')) {
            return;
        }

        Schema::create('propostas_credito', function (Blueprint $table) {
            $table->id();
            $table->string('numero', 50)->nullable();
            $table->string('status', 30)->default('nova');
            $table->decimal('valor_solicitado', 18, 2)->nullable();
            $table->unsignedInteger('prazo_meses')->nullable();
            $table->unsignedBigInteger('pessoa_fisica_id')->nullable();
            $table->unsignedBigInteger('pessoa_juridica_id')->nullable();
            $table->unsignedBigInteger('imovel_id')->nullable();
            $table->unsignedBigInteger('responsavel_id')->nullable();
            $table->timestamps();

            $table->index('pessoa_fisica_id');
            $table->index('pessoa_juridica_id');
            $table->index('imovel_id');
            $table->index('responsavel_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('propostas_credito');
    }
};
