<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('parceiros')) {
            return;
        }

        Schema::create('parceiros', function (Blueprint $table) {
            $table->id();
            $table->string('nome', 160);
            $table->string('tipo', 20)->default('banco');
            $table->string('canal_envio', 20)->default('email');
            $table->string('contato_nome', 120)->nullable();
            $table->string('contato_email', 160)->nullable();
            $table->string('contato_telefone', 40)->nullable();
            $table->string('api_url', 255)->nullable();
            $table->string('api_token', 255)->nullable();
            $table->string('api_key', 255)->nullable();
            $table->text('api_headers')->nullable();
            $table->boolean('ativo')->default(true);
            $table->timestamps();

            $table->index(['tipo', 'canal_envio']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('parceiros');
    }
};
