<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('agenda_eventos')) {
            return;
        }

        Schema::create('agenda_eventos', function (Blueprint $table) {
            $table->id();
            $table->string('titulo', 255);
            $table->text('descricao')->nullable();
            $table->dateTime('inicio_em');
            $table->dateTime('fim_em');
            $table->string('categoria', 40)->default('reuniao');
            $table->string('status', 40)->default('pendente');
            $table->string('prioridade', 20)->default('media');
            $table->string('localizacao', 255)->nullable();
            $table->text('notas')->nullable();
            $table->json('tags')->nullable();
            $table->json('relacionados')->nullable();
            $table->string('visibilidade', 20)->default('privado');
            $table->unsignedBigInteger('owner_id')->nullable();
            $table->unsignedBigInteger('created_by_id')->nullable();
            $table->unsignedBigInteger('updated_by_id')->nullable();
            $table->string('usuario_telefone', 40)->nullable();
            $table->unsignedBigInteger('cliente_id')->nullable();
            $table->string('cliente_nome', 255)->nullable();
            $table->string('cliente_telefone', 40)->nullable();
            $table->string('cliente_email', 255)->nullable();
            $table->unsignedInteger('lembrete_minutos')->default(60);
            $table->boolean('lembrete_sms_usuario')->default(true);
            $table->boolean('lembrete_sms_cliente')->default(false);
            $table->timestamps();

            $table->index('inicio_em');
            $table->index('fim_em');
            $table->index('owner_id');
            $table->index('created_by_id');
            $table->index('cliente_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('agenda_eventos');
    }
};
