<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('configuracoes')) {
            return;
        }

        if (!Schema::hasColumn('configuracoes', 'sms_texto_lead')) {
            Schema::table('configuracoes', function (Blueprint $table) {
                $table->text('sms_texto_lead')->nullable();
            });
        }
    }

    public function down(): void
    {
        if (!Schema::hasTable('configuracoes')) {
            return;
        }

        if (Schema::hasColumn('configuracoes', 'sms_texto_lead')) {
            Schema::table('configuracoes', function (Blueprint $table) {
                $table->dropColumn('sms_texto_lead');
            });
        }
    }
};
