<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('proposta_documento_validacoes', function (Blueprint ) {
            ->id();
            ->unsignedBigInteger('proposta_id');
            ->unsignedBigInteger('documento_id');
            ->string('status')->default('pendente');
            ->decimal('score', 6, 2)->nullable();
            ->longText('campos_json')->nullable();
            ->longText('alertas_json')->nullable();
            ->longText('extraido_json')->nullable();
            ->longText('texto_extraido')->nullable();
            ->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('proposta_documento_validacoes');
    }
};
