<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('configuracoes')) {
            return;
        }

        Schema::table('configuracoes', function (Blueprint $table) {
            if (!Schema::hasColumn('configuracoes', 'whatsapp_texto_lead')) {
                $table->text('whatsapp_texto_lead')->nullable();
            }
            if (!Schema::hasColumn('configuracoes', 'email_assunto_lead')) {
                $table->string('email_assunto_lead', 255)->nullable();
            }
            if (!Schema::hasColumn('configuracoes', 'email_texto_lead')) {
                $table->text('email_texto_lead')->nullable();
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('configuracoes')) {
            return;
        }

        Schema::table('configuracoes', function (Blueprint $table) {
            if (Schema::hasColumn('configuracoes', 'whatsapp_texto_lead')) {
                $table->dropColumn('whatsapp_texto_lead');
            }
            if (Schema::hasColumn('configuracoes', 'email_assunto_lead')) {
                $table->dropColumn('email_assunto_lead');
            }
            if (Schema::hasColumn('configuracoes', 'email_texto_lead')) {
                $table->dropColumn('email_texto_lead');
            }
        });
    }
};
