﻿import { createRouter, createWebHistory } from 'vue-router';
import DashboardLayout from '../layouts/DashboardLayout.vue';
import Dashboard from '../pages/Dashboard.vue';
import Leads from '../pages/Leads.vue';
import LeadDetalhes from '../pages/LeadDetalhes.vue';
import Login from '../pages/Login.vue';
import ModuloPlaceholder from '../pages/ModuloPlaceholder.vue';
import Juridico from '../pages/Juridico.vue';
import Operacional from '../pages/Operacional.vue';
import Propostas from '../pages/Propostas.vue';
import Contratos from '../pages/Contratos.vue';
import Imoveis from '../pages/Imoveis.vue';
import PessoasFisicas from '../pages/PessoasFisicas.vue';
import PessoasJuridicas from '../pages/PessoasJuridicas.vue';
import Financeiro from '../pages/Financeiro.vue';
import Configuracoes from '../pages/Configuracoes.vue';
import Compliance from '../pages/Compliance.vue';
import { authStore, initAuth } from '../store/auth';

const routes = [
  { path: '/', name: 'login', component: Login },
  {
    path: '/app',
    component: DashboardLayout,
    meta: { requiresAuth: true },
    children: [
      { path: 'dashboard', name: 'dashboard', component: Dashboard },
      { path: 'leads', name: 'leads', component: Leads },
      { path: 'leads/:id', name: 'lead-detalhes', component: LeadDetalhes },
      { path: 'propostas', name: 'propostas', component: Propostas },
      { path: 'contratos', name: 'contratos', component: Contratos },
      { path: 'imoveis', name: 'imoveis', component: Imoveis },
      { path: 'pessoas-fisicas', name: 'pessoas-fisicas', component: PessoasFisicas },
      { path: 'pessoas-juridicas', name: 'pessoas-juridicas', component: PessoasJuridicas },
      { path: 'credito', name: 'credito', component: ModuloPlaceholder },
      { path: 'imobiliario', name: 'imobiliario', component: ModuloPlaceholder },
      { path: 'financeiro', name: 'financeiro', component: Financeiro },
      { path: 'juridico', name: 'juridico', component: Juridico },
      { path: 'operacional', name: 'operacional', component: Operacional },
      { path: 'compliance', name: 'compliance', component: Compliance },
      { path: 'configuracoes', name: 'configuracoes', component: Configuracoes },
    ],
  },
];

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes,
});

router.beforeEach(async (to) => {
  if (!authStore.initialized) {
    await initAuth();
  }

  if (to.meta.requiresAuth && !authStore.isAuthenticated) {
    return { name: 'login' };
  }

  if (to.name === 'login' && authStore.isAuthenticated) {
    return { name: 'dashboard' };
  }

  return true;
});

export default router;
