﻿import { createRouter, createWebHistory } from 'vue-router';
import DashboardLayout from '../layouts/DashboardLayout.vue';
import Dashboard from '../pages/Dashboard.vue';
import Leads from '../pages/Leads.vue';
import LeadDetalhes from '../pages/LeadDetalhes.vue';
import Login from '../pages/Login.vue';
import ModuloPlaceholder from '../pages/ModuloPlaceholder.vue';
import Financeiro from '../pages/Financeiro.vue';
import Juridico from '../pages/Juridico.vue';
import Operacional from '../pages/Operacional.vue';
import Compliance from '../pages/Compliance.vue';
import Configuracoes from '../pages/Configuracoes.vue';
import Propostas from '../pages/Propostas.vue';
import PropostaDetalhes from '../pages/PropostaDetalhes.vue';
import Contratos from '../pages/Contratos.vue';
import Imoveis from '../pages/Imoveis.vue';
import PessoasFisicas from '../pages/PessoasFisicas.vue';
import PessoasJuridicas from '../pages/PessoasJuridicas.vue';
import Parceiros from '../pages/Parceiros.vue';
import { authStore, initAuth } from '../store/auth';
import Agenda from '../pages/Agenda.vue';

const routes = [
  { path: '/', name: 'login', component: Login },
  {
    path: '/app',
    component: DashboardLayout,
    meta: { requiresAuth: true },
    children: [
      {
        path: 'dashboard',
        name: 'dashboard',
        component: Dashboard,
        meta: { roles: ['admin', 'gestor', 'operacional'] },
      },
      { path: 'leads', name: 'leads', component: Leads, meta: { roles: ['admin', 'gestor', 'operacional'] } },
      {
        path: 'leads/:id',
        name: 'lead-detalhes',
        component: LeadDetalhes,
        meta: { roles: ['admin', 'gestor', 'operacional'] },
      },
      { path: 'propostas', name: 'propostas', component: Propostas, meta: { roles: ['admin', 'gestor'] } },
      {
        path: 'propostas/:id',
        name: 'proposta-detalhes',
        component: PropostaDetalhes,
        meta: { roles: ['admin', 'gestor'] },
      },
      { path: 'contratos', name: 'contratos', component: Contratos, meta: { roles: ['admin', 'gestor'] } },
      { path: 'imoveis', name: 'imoveis', component: Imoveis, meta: { roles: ['admin', 'gestor'] } },
      {
        path: 'pessoas-fisicas',
        name: 'pessoas-fisicas',
        component: PessoasFisicas,
        meta: { roles: ['admin', 'gestor', 'operacional'] },
      },
      {
        path: 'pessoas-juridicas',
        name: 'pessoas-juridicas',
        component: PessoasJuridicas,
        meta: { roles: ['admin', 'gestor', 'operacional'] },
      },
      { path: 'credito', name: 'credito', component: ModuloPlaceholder, meta: { roles: ['admin', 'gestor'] } },
      {
        path: 'imobiliario',
        name: 'imobiliario',
        component: ModuloPlaceholder,
        meta: { roles: ['admin', 'gestor'] },
      },
      { path: 'financeiro', name: 'financeiro', component: Financeiro, meta: { roles: ['admin'] } },
      { path: 'juridico', name: 'juridico', component: Juridico, meta: { roles: ['admin', 'gestor'] } },
      {
        path: 'operacional',
        name: 'operacional',
        component: Operacional,
        meta: { roles: ['admin', 'gestor', 'operacional'] },
      },
      { path: 'compliance', name: 'compliance', component: Compliance, meta: { roles: ['admin', 'gestor'] } },
      { path: 'parceiros', name: 'parceiros', component: Parceiros, meta: { roles: ['admin', 'gestor'] } },
      { path: 'agenda', name: 'agenda', component: Agenda, meta: { roles: ['admin', 'gestor', 'operacional'] } },
      { path: 'configuracoes', name: 'configuracoes', component: Configuracoes, meta: { roles: ['admin'] } },
    ],
  },
];

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes,
});

router.beforeEach(async (to) => {
  if (!authStore.initialized) {
    await initAuth();
  }

  if (to.meta.requiresAuth && !authStore.isAuthenticated) {
    return { name: 'login' };
  }

  if (to.name === 'login' && authStore.isAuthenticated) {
    return { name: 'dashboard' };
  }

  if (to.meta.roles && authStore.isAuthenticated) {
    const role = String(authStore.user?.role || 'operacional').toLowerCase();
    if (!to.meta.roles.includes(role)) {
      return { name: 'dashboard' };
    }
  }

  return true;
});

export default router;
