<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\LeadService;

class LeadController extends Controller
{
    public function __construct(private LeadService $leadService) {}

    public function index()
    {
        return response()->json($this->leadService->list());
    }

    public function create()
    {
        return view('leads.create');
    }

    public function store(Request $request)
    {
        return response()->json($this->leadService->create($request->all()), 201);
    }

    public function show(string $id)
    {
        return response()->json($this->leadService->find($id));
    }

    public function edit(string $id)
    {
        return view('leads.edit', ['lead' => $this->leadService->find($id)]);
    }

    public function update(Request $request, string $id)
    {
        return response()->json($this->leadService->update($id, $request->all()));
    }

    public function destroy(string $id)
    {
        $this->leadService->delete($id);
        return response()->json(['message' => 'Lead removido']);
    }

    public function updateStatus(Request $request, string $id)
    {
        return response()->json($this->leadService->updateStatus($id, $request->input('status')));
    }

    public function assignResponsavel(Request $request, string $id)
    {
        return response()->json($this->leadService->assignResponsavel($id, $request->input('usuario_id')));
    }

    public function convertToProposta(string $id)
    {
        return response()->json($this->leadService->convertToProposta($id));
    }
}
