<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContratoIndexador extends Model
{
    use HasFactory;

    protected $fillable = [
        'contrato_id',
        'indexador',
        'valor',
        'vigencia_inicio',
        'vigencia_fim',
    ];

    public function contrato()
    {
        return $this->belongsTo(ContratoCredito::class, 'contrato_id');
    }
}
