<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Imovel extends Model
{
    use HasFactory;

    protected $fillable = [
        'descricao',
        'tipo',
        'endereco_id',
        'valor_estimado',
        'status',
        'proprietario_id',
        'proprietario_tipo',
    ];

    public function endereco()
    {
        return $this->belongsTo(Endereco::class);
    }

    public function documentacoes()
    {
        return $this->hasMany(ImovelDocumentacao::class);
    }

    public function fotos()
    {
        return $this->hasMany(ImovelFoto::class);
    }

    public function avaliacoes()
    {
        return $this->hasMany(ImovelAvaliacao::class);
    }

    public function laudos()
    {
        return $this->hasMany(ImovelLaudo::class);
    }

    public function garantias()
    {
        return $this->hasMany(ImovelGarantia::class);
    }

    public function vistorias()
    {
        return $this->hasMany(Vistoria::class);
    }

    public function propostas()
    {
        return $this->hasMany(PropostaCredito::class);
    }

    public function contratos()
    {
        return $this->hasMany(ContratoCredito::class);
    }
}
