<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Vistoria extends Model
{
    use HasFactory;

    protected $fillable = [
        'imovel_id',
        'vistoriador',
        'data',
        'status',
    ];

    public function imovel()
    {
        return $this->belongsTo(Imovel::class);
    }

    public function itens()
    {
        return $this->hasMany(ItemVistoria::class);
    }

    public function fotos()
    {
        return $this->hasMany(VistoriaFoto::class);
    }
}
