<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PessoaFisica extends Model
{
    protected $table = 'pessoas_fisicas';

    protected $primaryKey = 'cliente_id';

    public $incrementing = false;

    protected $fillable = [
        'cliente_id',
        'profissao',
        'renda_mensal',
        'conjuge_nome',
        'conjuge_data_nascimento',
        'conjuge_estado_civil',
    ];

    public function cliente()
    {
        return $this->belongsTo(Cliente::class, 'cliente_id');
    }

    public function socios()
    {
        return $this->hasMany(Socio::class);
    }

    public function enderecos()
    {
        return $this->hasMany(Endereco::class);
    }

    public function contatos()
    {
        return $this->hasMany(Contato::class);
    }

    public function imoveis()
    {
        return $this->hasMany(Imovel::class);
    }

    public function propostaCreditos()
    {
        return $this->hasMany(PropostaCredito::class);
    }

    public function contratoCreditos()
    {
        return $this->hasMany(ContratoCredito::class);
    }

    public function kycs()
    {
        return $this->hasMany(KYC::class);
    }

    public function amls()
    {
        return $this->hasMany(AML::class);
    }

    public function leads()
    {
        return $this->hasMany(Lead::class, 'pessoa_fisica_id', 'cliente_id');
    }

}

