<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Lead extends Model
{
    protected $table = 'leads';

    protected $fillable = [
        'nome',
        'email',
        'telefone',
        'origem',
        'status',
        'responsavel_id',
        'pessoa_fisica_id',
        'pessoa_juridica_id',
        'external_source',
        'external_id',
        'validated_at',
        'tipo_solicitacao',
    ];

    public function responsavel()
    {
        return $this->belongsTo(Usuario::class, 'responsavel_id');
    }

    public function pessoaFisica()
    {
        return $this->belongsTo(PessoaFisica::class, 'pessoa_fisica_id', 'cliente_id');
    }

    public function pessoaJuridica()
    {
        return $this->belongsTo(PessoaJuridica::class, 'pessoa_juridica_id', 'cliente_id');
    }

}

