<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TarefaOperacional extends Model
{
    protected $fillable = ['titulo', 'descricao', 'status', 'usuario_id', 'workflow_etapa_id', 'prazo'];

    public function usuario()
    {
        return $this->belongsTo(Usuario::class);
    }

    public function workflowEtapa()
    {
        return $this->belongsTo(WorkflowEtapa::class);
    }

    public function checklistsOperacionais()
    {
        return $this->hasMany(ChecklistOperacional::class);
    }

}

