<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('configuracoes')) {
            return;
        }

        if (!Schema::hasColumn('configuracoes', 'sms_api_url')) {
            Schema::table('configuracoes', function (Blueprint $table) {
                $table->string('sms_api_url')->nullable();
            });
        }
        if (!Schema::hasColumn('configuracoes', 'sms_auth_key')) {
            Schema::table('configuracoes', function (Blueprint $table) {
                $table->string('sms_auth_key')->nullable();
            });
        }
        if (!Schema::hasColumn('configuracoes', 'sms_sender')) {
            Schema::table('configuracoes', function (Blueprint $table) {
                $table->string('sms_sender')->nullable();
            });
        }
        if (!Schema::hasColumn('configuracoes', 'sms_sender_contrato')) {
            Schema::table('configuracoes', function (Blueprint $table) {
                $table->string('sms_sender_contrato')->nullable();
            });
        }
        if (!Schema::hasColumn('configuracoes', 'sms_texto_proposta')) {
            Schema::table('configuracoes', function (Blueprint $table) {
                $table->text('sms_texto_proposta')->nullable();
            });
        }
        if (!Schema::hasColumn('configuracoes', 'sms_texto_contrato')) {
            Schema::table('configuracoes', function (Blueprint $table) {
                $table->text('sms_texto_contrato')->nullable();
            });
        }
        if (!Schema::hasColumn('configuracoes', 'sms_texto_agenda_usuario')) {
            Schema::table('configuracoes', function (Blueprint $table) {
                $table->text('sms_texto_agenda_usuario')->nullable();
            });
        }
        if (!Schema::hasColumn('configuracoes', 'sms_texto_agenda_cliente')) {
            Schema::table('configuracoes', function (Blueprint $table) {
                $table->text('sms_texto_agenda_cliente')->nullable();
            });
        }
    }

    public function down(): void
    {
        if (!Schema::hasTable('configuracoes')) {
            return;
        }

        Schema::table('configuracoes', function (Blueprint $table) {
            if (Schema::hasColumn('configuracoes', 'sms_api_url')) {
                $table->dropColumn('sms_api_url');
            }
            if (Schema::hasColumn('configuracoes', 'sms_auth_key')) {
                $table->dropColumn('sms_auth_key');
            }
            if (Schema::hasColumn('configuracoes', 'sms_sender')) {
                $table->dropColumn('sms_sender');
            }
            if (Schema::hasColumn('configuracoes', 'sms_sender_contrato')) {
                $table->dropColumn('sms_sender_contrato');
            }
            if (Schema::hasColumn('configuracoes', 'sms_texto_proposta')) {
                $table->dropColumn('sms_texto_proposta');
            }
            if (Schema::hasColumn('configuracoes', 'sms_texto_contrato')) {
                $table->dropColumn('sms_texto_contrato');
            }
            if (Schema::hasColumn('configuracoes', 'sms_texto_agenda_usuario')) {
                $table->dropColumn('sms_texto_agenda_usuario');
            }
            if (Schema::hasColumn('configuracoes', 'sms_texto_agenda_cliente')) {
                $table->dropColumn('sms_texto_agenda_cliente');
            }
        });
    }
};
