<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('configuracoes')) {
            return;
        }

        $addProposta = !Schema::hasColumn('configuracoes', 'sms_texto_proposta');
        $addContrato = !Schema::hasColumn('configuracoes', 'sms_texto_contrato');
        if ($addProposta || $addContrato) {
            Schema::table('configuracoes', function (Blueprint $table) use ($addProposta, $addContrato) {
                if ($addProposta) {
                    $table->text('sms_texto_proposta')->nullable();
                }
                if ($addContrato) {
                    $table->text('sms_texto_contrato')->nullable();
                }
            });
        }
    }

    public function down(): void
    {
        if (!Schema::hasTable('configuracoes')) {
            return;
        }

        $dropProposta = Schema::hasColumn('configuracoes', 'sms_texto_proposta');
        $dropContrato = Schema::hasColumn('configuracoes', 'sms_texto_contrato');
        if ($dropProposta || $dropContrato) {
            Schema::table('configuracoes', function (Blueprint $table) use ($dropProposta, $dropContrato) {
                if ($dropProposta) {
                    $table->dropColumn('sms_texto_proposta');
                }
                if ($dropContrato) {
                    $table->dropColumn('sms_texto_contrato');
                }
            });
        }
    }
};
