import { defineStore } from 'pinia'
import axios from 'axios'

export const useAuthStore = defineStore('auth', {
  state: () => ({ user: null, token: null, loading: false, error: null }),
  actions: {
    async login(email, password) {
      this.loading = true
      this.error = null
      try {
        const { data } = await axios.post('/login', { email, password })
        this.user = data.user || { name: email }
        this.token = data.token || null
      } catch (err) {
        this.error = err.response?.data?.message || 'Falha no login'
        throw err
      } finally {
        this.loading = false
      }
    },
    logout() {
      this.user = null
      this.token = null
    },
  },
})
