<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ParcelaContrato extends Model
{
    use HasFactory;

    protected $fillable = [
        'contrato_id',
        'numero',
        'valor',
        'vencimento',
        'status',
    ];

    public function contrato()
    {
        return $this->belongsTo(ContratoCredito::class, 'contrato_id');
    }

    public function pagamentos()
    {
        return $this->hasMany(Pagamento::class, 'parcela_id');
    }
}
