<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Socio extends Model
{
    use HasFactory;

    protected $fillable = [
        'pessoa_juridica_id',
        'pessoa_fisica_id',
        'percentual',
    ];

    public function pessoaJuridica()
    {
        return $this->belongsTo(PessoaJuridica::class, 'pessoa_juridica_id');
    }

    public function pessoaFisica()
    {
        return $this->belongsTo(PessoaFisica::class, 'pessoa_fisica_id');
    }
}
