<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\ImovelService;

class ImovelController extends Controller
{
    public function __construct(private ImovelService $imovelService) {}

    public function index()
    {
        return response()->json($this->imovelService->list());
    }

    public function store(Request $request)
    {
        return response()->json($this->imovelService->create($request->all()), 201);
    }

    public function show(string $id)
    {
        return response()->json($this->imovelService->find($id));
    }

    public function update(Request $request, string $id)
    {
        return response()->json($this->imovelService->update($id, $request->all()));
    }

    public function destroy(string $id)
    {
        $this->imovelService->delete($id);
        return response()->json(['message' => 'Im?vel removido']);
    }
}
