<?php

namespace App\Services;

use App\Models\PropostaCredito;

class PropostaService
{
    public function list()
    {
        return PropostaCredito::with(['lead','imovel'])->latest()->paginate();
    }

    public function find(string $id)
    {
        return PropostaCredito::with(['lead','imovel'])->findOrFail($id);
    }

    public function create(array $data)
    {
        return PropostaCredito::create($data);
    }

    public function update(string $id, array $data)
    {
        $proposta = PropostaCredito::findOrFail($id);
        $proposta->update($data);
        return $proposta;
    }

    public function delete(string $id): void
    {
        PropostaCredito::findOrFail($id)->delete();
    }
}
