<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\PessoaFisicaController;
use App\Http\Controllers\PessoaJuridicaController;
use App\Http\Controllers\ImovelController;
use App\Http\Controllers\PropostaCreditoController;
use App\Http\Controllers\ContratoCreditoController;
use App\Http\Controllers\LeadController;
use App\Http\Controllers\FinanceiroController;
use App\Http\Controllers\JuridicoController;
use App\Http\Controllers\OperacionalController;
use App\Http\Controllers\ComplianceController;
use App\Http\Controllers\ConfiguracoesController;

Route::get('/', [AuthController::class, 'login'])->name('login');
Route::post('/login', [AuthController::class, 'authenticate']);

Route::middleware(['auth'])->group(function() {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    Route::resource('pessoas-fisicas', PessoaFisicaController::class);
    Route::resource('pessoas-juridicas', PessoaJuridicaController::class);
    Route::resource('imoveis', ImovelController::class);
    Route::resource('propostas', PropostaCreditoController::class);
    Route::resource('contratos', ContratoCreditoController::class);
    Route::resource('leads', LeadController::class);

    Route::get('/financeiro', [FinanceiroController::class, 'index']);
    Route::get('/juridico', [JuridicoController::class, 'index']);
    Route::get('/operacional', [OperacionalController::class, 'index']);
    Route::get('/compliance', [ComplianceController::class, 'index']);
    Route::get('/configuracoes', [ConfiguracoesController::class, 'index']);
});
