<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ContratoGarantia extends Model
{
    protected $table = 'contratos_garantias';

    protected $fillable = ['contrato_id', 'imovel_id', 'tipo_garantia_id', 'percentual_cobertura'];

    public function contratoCredito()
    {
        return $this->belongsTo(ContratoCredito::class, 'contrato_id');
    }

    public function imovel()
    {
        return $this->belongsTo(Imovel::class);
    }

}

