<?php

namespace App\Http\Controllers;

use App\Models\Cliente;
use Illuminate\Http\Request;

class ClienteController extends Controller
{
    public function index(Request $request)
    {
        $query = Cliente::query();
        $search = trim((string) $request->get('search', ''));

        if ($search !== '') {
            $digits = preg_replace('/\D+/', '', $search);
            $query->where(function ($builder) use ($search, $digits) {
                $builder->where('nome_razao', 'like', '%'.$search.'%')
                    ->orWhere('cpf_cnpj', 'like', '%'.$search.'%');

                if ($digits !== '') {
                    $builder->orWhereRaw(
                        "REPLACE(REPLACE(REPLACE(cpf_cnpj, '.', ''), '-', ''), '/', '') LIKE ?",
                        ['%'.$digits.'%']
                    )->orWhereRaw('CAST(id AS CHAR) LIKE ?', ['%'.$digits.'%']);
                }
            });

            $limit = (int) $request->get('limit', 80);
            $limit = max(1, min($limit, 200));
            $clientes = $query->orderByDesc('id')->limit($limit)->get();
            return response()->json($clientes);
        }

        $clientes = $query->orderByDesc('id')->paginate(20);

        return response()->json($clientes);
    }

    public function create()
    {
        return response()->json(['message' => 'create']);
    }

    public function store(Request $request)
    {
        $cliente = Cliente::query()->create($request->only([
            'tipo_cliente',
            'nome_razao',
            'cpf_cnpj',
            'data_nascimento',
            'estado_civil',
            'renda',
            'usuario_responsavel',
            'status',
        ]));

        return response()->json($cliente, 201);
    }

    public function show(int $id)
    {
        return response()->json(Cliente::query()->findOrFail($id));
    }

    public function edit(int $id)
    {
        return response()->json(Cliente::query()->findOrFail($id));
    }

    public function update(Request $request, int $id)
    {
        $cliente = Cliente::query()->findOrFail($id);
        $cliente->update($request->only([
            'nome_razao',
            'cpf_cnpj',
            'data_nascimento',
            'estado_civil',
            'renda',
            'usuario_responsavel',
            'status',
        ]));

        return response()->json($cliente);
    }

    public function destroy(int $id)
    {
        Cliente::query()->whereKey($id)->delete();
        return response()->noContent();
    }
}
