<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AgendaEventoParticipante extends Model
{
    protected $table = 'agenda_evento_participantes';

    protected $fillable = [
        'evento_id',
        'usuario_id',
        'status',
        'respondido_em',
        'lembrete_sms',
    ];

    protected $casts = [
        'respondido_em' => 'datetime',
        'lembrete_sms' => 'boolean',
    ];

    public function evento()
    {
        return $this->belongsTo(AgendaEvento::class, 'evento_id');
    }

    public function usuario()
    {
        return $this->belongsTo(Usuario::class, 'usuario_id');
    }
}
