<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Cliente extends Model
{
    protected $table = 'clientes';

    public $timestamps = false;

    protected $fillable = [
        'tipo_cliente',
        'nome_razao',
        'cpf_cnpj',
        'data_nascimento',
        'estado_civil',
        'renda',
        'usuario_responsavel',
        'status',
    ];

    public function pessoaFisica()
    {
        return $this->hasOne(PessoaFisica::class, 'cliente_id');
    }

    public function pessoaJuridica()
    {
        return $this->hasOne(PessoaJuridica::class, 'cliente_id');
    }

    public function imoveis()
    {
        return $this->hasMany(Imovel::class, 'cliente_id');
    }

    public function propostasCredito()
    {
        return $this->hasMany(PropostaCredito::class, 'cliente_id');
    }

    public function contratosCredito()
    {
        return $this->hasMany(ContratoCredito::class, 'cliente_id');
    }
}
