<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ContratoDocumentoSolicitacao extends Model
{
    protected $table = 'contrato_documento_solicitacoes';

    protected $fillable = [
        'contrato_id',
        'token',
        'canal',
        'destinatario',
        'tipo_cliente',
        'nome_cliente',
        'objetivo',
        'status',
    ];

    public function contratoCredito()
    {
        return $this->belongsTo(ContratoCredito::class, 'contrato_id');
    }
}
