<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProcessoJuridico extends Model
{
    protected $fillable = ['contrato_credito_id', 'imovel_id', 'status', 'descricao'];

    public function contratoCredito()
    {
        return $this->belongsTo(ContratoCredito::class);
    }

    public function imovel()
    {
        return $this->belongsTo(Imovel::class);
    }

    public function documentoJuridicos()
    {
        return $this->hasMany(DocumentoJuridico::class);
    }

    public function certidaos()
    {
        return $this->hasMany(Certidao::class);
    }

    public function pendenciaJuridicas()
    {
        return $this->hasMany(PendenciaJuridica::class);
    }

}

