<?php

namespace App\Repositories;

use Illuminate\Database\Eloquent\Model;

abstract class BaseRepository implements RepositoryInterface
{
    protected Model $model;

    public function __construct(Model $model)
    {
        $this->model = $model;
    }

    public function all()
    {
        return $this->model->newQuery()->get();
    }

    public function find(int $id)
    {
        return $this->model->newQuery()->findOrFail($id);
    }

    public function create(array $data)
    {
        return $this->model->newQuery()->create($data);
    }

    public function update(int $id, array $data)
    {
        $record = $this->find($id);
        $record->fill($data);
        $record->save();

        return $record;
    }

    public function delete(int $id): bool
    {
        return (bool) $this->model->newQuery()->whereKey($id)->delete();
    }
}
