<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('contratos_credito')) {
            return;
        }

        Schema::create('contratos_credito', function (Blueprint $table) {
            $table->id();
            $table->string('numero', 50)->nullable();
            $table->string('status', 30)->nullable();
            $table->decimal('valor_contratado', 18, 2)->nullable();
            $table->date('data_inicio')->nullable();
            $table->date('data_fim')->nullable();
            $table->unsignedBigInteger('proposta_credito_id')->nullable();
            $table->unsignedBigInteger('pessoa_fisica_id')->nullable();
            $table->unsignedBigInteger('pessoa_juridica_id')->nullable();
            $table->timestamps();

            $table->index('proposta_credito_id');
            $table->index('pessoa_fisica_id');
            $table->index('pessoa_juridica_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('contratos_credito');
    }
};
