<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('configuracoes')) {
            return;
        }

        Schema::create('configuracoes', function (Blueprint $table) {
            $table->id();
            $table->string('whatsapp_api_url', 255)->nullable();
            $table->text('whatsapp_api_token')->nullable();
            $table->text('whatsapp_api_key')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('configuracoes');
    }
};
