<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('contrato_documento_solicitacoes')) {
            return;
        }

        Schema::create('contrato_documento_solicitacoes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('contrato_id');
            $table->string('token', 64)->unique();
            $table->string('canal', 20);
            $table->string('destinatario', 255)->nullable();
            $table->string('tipo_cliente', 2)->nullable();
            $table->string('nome_cliente', 160)->nullable();
            $table->string('objetivo', 255)->nullable();
            $table->string('status', 40)->default('pendente');
            $table->timestamps();

            $table->index('contrato_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('contrato_documento_solicitacoes');
    }
};
