<?php

namespace App\Services;

use App\Models\Lead;
use App\Models\PropostaCredito;
use App\Models\ContratoCredito;

class DashboardService
{
    public function summary()
    {
        return [
            'leads_do_dia' => Lead::whereDate('created_at', now()->toDateString())->count(),
            'propostas_por_status' => PropostaCredito::selectRaw('status, count(*) as total')->groupBy('status')->pluck('total','status'),
            'contratos_por_status' => ContratoCredito::selectRaw('status, count(*) as total')->groupBy('status')->pluck('total','status'),
            'exposicao_risco' => 0,
        ];
    }
}
