<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Imovel extends Model
{
    protected $table = 'imoveis';

    protected $fillable = [
        'cliente_id',
        'tipo_imovel_id',
        'cep',
        'logradouro',
        'numero',
        'bairro',
        'cidade',
        'estado',
        'metragem_m2',
        'valor_avaliacao',
        'valor_credito',
        'saldo_devedor',
        'em_condominio',
        'propriedade',
    ];

    public function cliente()
    {
        return $this->belongsTo(Cliente::class, 'cliente_id');
    }

    public function imovelDocumentacoes()
    {
        return $this->hasMany(ImovelDocumentacao::class);
    }

    public function imovelFotos()
    {
        return $this->hasMany(ImovelFoto::class);
    }

    public function imovelAvaliacoes()
    {
        return $this->hasMany(ImovelAvaliacao::class);
    }

    public function imovelLaudos()
    {
        return $this->hasMany(ImovelLaudo::class);
    }

    public function imovelGarantias()
    {
        return $this->hasMany(ImovelGarantia::class);
    }

    public function vistorias()
    {
        return $this->hasMany(Vistoria::class);
    }

    public function propostaCreditos()
    {
        return $this->belongsToMany(PropostaCredito::class, 'proposta_imovel', 'imovel_id', 'proposta_id');
    }

    public function contratoGarantias()
    {
        return $this->hasMany(ContratoGarantia::class, 'imovel_id');
    }

    public function processoJuridicos()
    {
        return $this->hasMany(ProcessoJuridico::class);
    }

    public function registrosImoveis()
    {
        return $this->hasMany(RegistroImovel::class);
    }

}

