<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    public function login()
    {
        $user = Auth::user();

        return response()->json([
            'authenticated' => (bool) $user,
            'user' => $user ? $this->userPayload($user) : null,
        ]);
    }

    public function authenticate(Request $request)
    {
        $credentials = $request->validate([
            'email' => ['required', 'email'],
            'password' => ['required', 'string'],
        ]);

        if (!Auth::attempt($credentials, $request->boolean('remember'))) {
            return response()->json([
                'message' => 'Credenciais invalidas.',
            ], 422);
        }

        $request->session()->regenerate();

        return response()->json([
            'message' => 'Login realizado.',
            'user' => $this->userPayload(Auth::user()),
        ]);
    }

    public function me(Request $request)
    {
        if (!$request->user()) {
            return response()->json(['message' => 'Nao autenticado.'], 401);
        }

        return response()->json([
            'user' => $this->userPayload($request->user()),
        ]);
    }

    public function csrf()
    {
        return response()->json([
            'csrf_token' => csrf_token(),
        ]);
    }

    public function logout(Request $request)
    {
        Auth::logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return response()->json(['message' => 'Logout realizado.']);
    }

    private function userPayload($user): array
    {
        return [
            'id' => $user->id,
            'name' => $user->name,
            'email' => $user->email,
            'role' => $user->role,
            'perfil_acesso_id' => $user->perfil_acesso_id,
            'ativo' => $user->ativo,
        ];
    }
}
