<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    protected function requireRole(array $roles): void
    {
        $user = auth()->user();
        $role = strtolower(trim((string) ($user->role ?? '')));
        if (!$role || !in_array($role, $roles, true)) {
            abort(403, 'Acesso negado.');
        }
    }
}
